/*
 Navicat MySQL Data Transfer

 Source Server         : system
 Source Server Type    : MySQL
 Source Server Version : 50735 (5.7.35-log)
 Source Host           : localhost:3306
 Source Schema         : demo_project

 Target Server Type    : MySQL
 Target Server Version : 50735 (5.7.35-log)
 File Encoding         : 65001

 Date: 15/09/2022 23:30:16
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for _cache
-- ----------------------------
DROP TABLE IF EXISTS `_cache`;
CREATE TABLE `_cache`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT '用户Id',
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL COMMENT '缓存数据',
  `recordStatus` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT 'active',
  `operation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT 'insert' COMMENT '操作; insert, update, jhInsert, jhUpdate, jhDelete jhRestore',
  `operationByUserId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者userId',
  `operationByUser` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者用户名',
  `operationAt` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作时间; E.g: 2021-05-28T10:24:54+08:00 ',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = '缓存表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of _cache
-- ----------------------------

-- ----------------------------
-- Table structure for _constant
-- ----------------------------
DROP TABLE IF EXISTS `_constant`;
CREATE TABLE `_constant`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `constantKey` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `constantType` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '常量类型; object, array',
  `desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '描述',
  `constantValue` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL COMMENT '常量内容; object, array',
  `operation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT 'insert' COMMENT '操作; insert, update, jhInsert, jhUpdate, jhDelete jhRestore',
  `operationByUserId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者userId',
  `operationByUser` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者用户名',
  `operationAt` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作时间; E.g: 2021-05-28T10:24:54+08:00 ',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = '常量表; 软删除未启用;' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of _constant
-- ----------------------------

-- ----------------------------
-- Table structure for _file
-- ----------------------------
DROP TABLE IF EXISTS `_file`;
CREATE TABLE `_file`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fileId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT 'fileId',
  `fileDirectory` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '文件保存路径;',
  `filename` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '文件名;',
  `filenameStorage` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '文件保存名',
  `downloadPath` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '文件下载路径',
  `fileType` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '文件类型;(预留字段)',
  `fileDesc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '文件描述',
  `binarySize` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '文件二进制大小',
  `operation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT 'insert' COMMENT '操作; insert, update, jhInsert, jhUpdate, jhDelete jhRestore',
  `operationByUserId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者userId',
  `operationByUser` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者用户名',
  `operationAt` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作时间; E.g: 2021-05-28T10:24:54+08:00 ',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `fileId_index`(`fileId`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = '文件表; 软删除未启用;' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of _file
-- ----------------------------

-- ----------------------------
-- Table structure for _group
-- ----------------------------
DROP TABLE IF EXISTS `_group`;
CREATE TABLE `_group`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'groupId',
  `groupName` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '群组名',
  `groupDesc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '群组描述',
  `groupAvatar` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '群logo',
  `groupExtend` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT '{}' COMMENT '拓展字段; { groupNotice: \'xx\' }',
  `operation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT 'insert' COMMENT '操作; insert, update, jhInsert, jhUpdate, jhDelete jhRestore',
  `operationByUserId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者userId',
  `operationByUser` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者用户名',
  `operationAt` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作时间; E.g: 2021-05-28T10:24:54+08:00 ',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `groupId_index`(`groupId`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 9 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = '群组表; 软删除未启用;' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of _group
-- ----------------------------
INSERT INTO `_group` VALUES (1, 'adminGroup', '管理组', '管理组', NULL, '{}', 'insert', NULL, NULL, NULL);
INSERT INTO `_group` VALUES (6, 'wudang', '武当', '武当', NULL, '{}', 'insert', NULL, NULL, NULL);
INSERT INTO `_group` VALUES (7, 'gaibang', '丐帮', '丐帮', NULL, '{}', 'insert', NULL, NULL, NULL);
INSERT INTO `_group` VALUES (8, 'huashan', '华山派', '华山派', NULL, '{}', 'insert', NULL, NULL, NULL);

-- ----------------------------
-- Table structure for _page
-- ----------------------------
DROP TABLE IF EXISTS `_page`;
CREATE TABLE `_page`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pageId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT 'pageId',
  `pageFile` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT 'page文件指定; 默认使用pageId.html',
  `pageName` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT 'page name',
  `pageType` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '页面类型; showInMenu, dynamicInMenu',
  `sort` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `operation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT 'insert' COMMENT '操作; insert, update, jhInsert, jhUpdate, jhDelete jhRestore',
  `operationByUserId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者userId',
  `operationByUser` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者用户名',
  `operationAt` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作时间; E.g: 2021-05-28T10:24:54+08:00 ',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 43 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = '页面表; 软删除未启用;' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of _page
-- ----------------------------
INSERT INTO `_page` VALUES (2, 'help', NULL, '帮助', 'dynamicInMenu', '11', 'insert', NULL, NULL, NULL);
INSERT INTO `_page` VALUES (3, 'login', NULL, '登陆', '', '', 'insert', NULL, NULL, NULL);
INSERT INTO `_page` VALUES (6, 'manual', NULL, '操作手册', 'dynamicInMenu', '0', 'insert', NULL, NULL, NULL);
INSERT INTO `_page` VALUES (25, 'protocolDemo', NULL, '应用协议', 'showInMenu', '2', 'insert', NULL, NULL, NULL);
INSERT INTO `_page` VALUES (27, 'frontendDemo01', NULL, '前端对接', 'showInMenu', '3', 'insert', NULL, NULL, NULL);
INSERT INTO `_page` VALUES (28, 'frontendDemo02', NULL, '前端-jianghuAxios', 'showInMenu', '4', 'insert', NULL, NULL, NULL);
INSERT INTO `_page` VALUES (29, 'resourceHook', NULL, '前端-resouceHook', 'showInMenu', '6', 'insert', NULL, NULL, NULL);
INSERT INTO `_page` VALUES (31, 'backendSearchDemo', NULL, '服务端搜索', 'showInMenu', '7', 'insert', NULL, NULL, NULL);
INSERT INTO `_page` VALUES (32, 'dataAccessRight', NULL, '数据权限', 'showInMenu', '8', 'insert', NULL, NULL, NULL);
INSERT INTO `_page` VALUES (34, 'uiAction', NULL, 'uiAction', 'showInMenu', '5', 'insert', NULL, NULL, NULL);
INSERT INTO `_page` VALUES (35, 'uiActionComponent', NULL, 'uiAction-组件通信', 'showInMenu', '5', 'insert', NULL, NULL, NULL);
INSERT INTO `_page` VALUES (39, 'student3Management', NULL, 'student3Management页面', 'showInMenu', '5', 'insert', NULL, NULL, NULL);
INSERT INTO `_page` VALUES (40, 'protocolDemo2', NULL, '应用协议', 'showInMenu', '2', 'insert', NULL, NULL, NULL);
INSERT INTO `_page` VALUES (41, 'protocolDemoMenu', NULL, '菜谱', 'showInMenu', '1', 'insert', NULL, NULL, NULL);
INSERT INTO `_page` VALUES (42, 'protocolDemoOrder', NULL, '订单', 'showInMenu', '1', 'insert', NULL, NULL, NULL);

-- ----------------------------
-- Table structure for _record_history
-- ----------------------------
DROP TABLE IF EXISTS `_record_history`;
CREATE TABLE `_record_history`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `table` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '表',
  `recordId` int(11) NULL DEFAULT NULL COMMENT '数据在table中的主键id; recordContent.id',
  `recordContent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT '数据',
  `packageContent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT '当时请求的 package JSON',
  `operation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作; jhInsert, jhUpdate, jhDelete jhRestore',
  `operationByUserId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者userId; recordContent.operationByUserId',
  `operationByUser` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者用户名; recordContent.operationByUser',
  `operationAt` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作时间; recordContent.operationAt; E.g: 2021-05-28T10:24:54+08:00 ',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `index_record_id`(`recordId`) USING BTREE,
  INDEX `index_table_action`(`table`, `operation`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2161 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = '数据历史表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of _record_history
-- ----------------------------

-- ----------------------------
-- Table structure for _resource
-- ----------------------------
DROP TABLE IF EXISTS `_resource`;
CREATE TABLE `_resource`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `accessControlTable` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '数据规则控制表',
  `resourceHook` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL COMMENT '[ \"before\": {\"service\": \"xx\", \"serviceFunction\": \"xxx\"}, \"after\": [] }',
  `pageId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT 'page id; E.g: index',
  `actionId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT 'action id; E.g: selectXXXByXXX',
  `desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '描述',
  `resourceType` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT 'resource 类型; E.g: auth service sql',
  `appDataSchema` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL COMMENT 'appData 参数校验',
  `resourceData` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL COMMENT 'resource 数据; { \"service\": \"auth\", \"serviceFunction\": \"passwordLogin\" } or  { \"table\": \"${tableName}\", \"action\": \"select\", \"whereCondition\": \".where(function() {this.whereNot( { recordStatus: \\\"active\\\" })})\" }',
  `requestDemo` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL COMMENT '请求Demo',
  `responseDemo` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL COMMENT '响应Demo',
  `operation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT 'insert' COMMENT '操作; insert, update, jhInsert, jhUpdate, jhDelete jhRestore',
  `operationByUserId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者userId',
  `operationByUser` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者用户名',
  `operationAt` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作时间; E.g: 2021-05-28T10:24:54+08:00 ',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 386 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = '请求资源表; 软删除未启用; resourceId=`${appId}.${pageId}.${actionId}`' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of _resource
-- ----------------------------
INSERT INTO `_resource` VALUES (231, NULL, NULL, 'login', 'passwordLogin', '✅登陆', 'service', '{}', '{\"service\": \"user\", \"serviceFunction\": \"passwordLogin\"}', NULL, NULL, 'update', NULL, NULL, '2022-04-27T15:32:57+08:00');
INSERT INTO `_resource` VALUES (251, NULL, NULL, 'allPage', 'logout', '✅登出', 'service', '{}', '{\"service\": \"user\", \"serviceFunction\": \"logout\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (253, NULL, NULL, 'allPage', 'userInfo', '✅获取用户信息', 'service', '{}', '{\"service\": \"user\", \"serviceFunction\": \"userInfo\"}', NULL, NULL, 'update', NULL, NULL, '2022-04-27T15:37:21+08:00');
INSERT INTO `_resource` VALUES (258, NULL, NULL, 'allPage', 'getConstantList', '✅查询常量', 'sql', '{}', '{\"table\": \"_constant\", \"operation\": \"select\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (293, NULL, NULL, 'protocolDemo', 'selectItemList', '✅应用协议-查询列表', 'sql', '{}', '{\"table\": \"student3\", \"operation\": \"select\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (294, NULL, NULL, 'protocolDemo', 'insertItem', '✅应用协议-添加成员', 'sql', '{}', '{\"table\": \"student3\", \"operation\": \"insert\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (295, NULL, NULL, 'protocolDemo', 'updateItem', '✅应用协议-更新成员', 'sql', '{}', '{\"table\": \"student3\", \"operation\": \"jhUpdate\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (296, NULL, NULL, 'protocolDemo', 'deleteItem', '✅应用协议-删除信息', 'sql', '{}', '{\"table\": \"student3\", \"operation\": \"jhDelete\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (309, NULL, NULL, 'frontendDemo01', 'selectItemList', '✅前端对接-查询列表', 'sql', '{}', '{\"table\": \"student\", \"operation\": \"select\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (310, NULL, NULL, 'frontendDemo01', 'insertItem', '✅前端对接-添加成员', 'sql', '{}', '{\"table\": \"student\", \"operation\": \"insert\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (311, NULL, NULL, 'frontendDemo01', 'updateItem', '✅前端对接-更新成员', 'sql', '{}', '{\"table\": \"student\", \"operation\": \"jhUpdate\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (312, NULL, NULL, 'frontendDemo01', 'deleteItem', '✅前端对接-删除信息', 'sql', '{}', '{\"table\": \"student\", \"operation\": \"jhDelete\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (313, NULL, NULL, 'frontendDemo02', 'selectItemList', '✅前端优化-查询列表', 'sql', '{}', '{\"table\": \"student\", \"operation\": \"select\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (314, NULL, NULL, 'frontendDemo02', 'insertItem', '✅前端优化-添加成员', 'sql', '{}', '{\"table\": \"student\", \"operation\": \"jhInsert\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (315, NULL, NULL, 'frontendDemo02', 'updateItem', '✅前端优化-更新成员', 'sql', '{}', '{\"table\": \"student\", \"operation\": \"jhUpdate\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (316, NULL, NULL, 'frontendDemo02', 'deleteItem', '✅前端优化-删除信息', 'sql', '{}', '{\"table\": \"student\", \"operation\": \"jhDelete\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (317, NULL, NULL, 'resourceHook', 'selectItemList', '✅前端对接-业务ID-查询列表', 'sql', '{}', '{\"table\": \"student\", \"operation\": \"select\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (318, NULL, '{\"after\": [], \"before\": [{\"service\": \"student\", \"serviceFunction\": \"beforHookForGenerateStudentId\"}]}', 'resourceHook', 'insertItem', '✅前端对接-业务ID-添加成员', 'sql', '{\"type\": \"object\", \"required\": [\"actionData\"], \"properties\": {\"actionData\": {\"type\": \"object\", \"required\": [\"classId\", \"name\", \"level\", \"gender\", \"dateOfBirth\"], \"properties\": {\"name\": {\"type\": \"string\"}, \"level\": {\"anyOf\": [{\"type\": \"string\"}, {\"type\": \"number\"}]}, \"gender\": {\"type\": \"string\"}, \"classId\": {\"type\": \"string\"}, \"dateOfBirth\": {\"type\": \"string\", \"format\": \"date\"}}, \"additionalProperties\": true}}, \"additionalProperties\": true}', '{\"table\": \"student\", \"operation\": \"jhInsert\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (319, NULL, NULL, 'resourceHook', 'updateItem', '✅前端对接-业务ID-更新成员', 'sql', '{}', '{\"table\": \"student\", \"operation\": \"jhUpdate\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (320, NULL, NULL, 'resourceHook', 'deleteItem', '✅前端对接-业务ID-删除信息', 'sql', '{}', '{\"table\": \"student\", \"operation\": \"jhDelete\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (325, NULL, NULL, 'uiAction', 'selectItemList', '✅前端规范-查询列表', 'sql', '{}', '{\"table\": \"student\", \"operation\": \"select\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (326, NULL, NULL, 'uiAction', 'createItem', '✅前端规范-添加成员', 'sql', '{}', '{\"table\": \"student\", \"operation\": \"jhInsert\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (327, NULL, NULL, 'uiAction', 'updateItem', '✅前端规范-更新成员', 'sql', '{}', '{\"table\": \"student\", \"operation\": \"jhUpdate\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (328, NULL, NULL, 'uiAction', 'deleteItem', '✅前端规范-删除信息', 'sql', '{}', '{\"table\": \"student\", \"operation\": \"jhDelete\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (331, NULL, NULL, 'uiActionComponent', 'selectItemList', '✅前端规范-组件通信-查询列表', 'sql', '{}', '{\"table\": \"student\", \"operation\": \"select\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (332, NULL, NULL, 'uiActionComponent', 'insertItem', '✅前端规范-组件通信-添加成员', 'sql', '{}', '{\"table\": \"student\", \"operation\": \"jhInsert\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (333, NULL, NULL, 'uiActionComponent', 'updateItem', '✅前端规范-组件通信-更新成员', 'sql', '{}', '{\"table\": \"student\", \"operation\": \"jhUpdate\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (334, NULL, NULL, 'uiActionComponent', 'deleteItem', '✅前端规范-组件通信-删除信息', 'sql', '{}', '{\"table\": \"student\", \"operation\": \"jhDelete\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (341, 'access_control_student', NULL, 'backendSearchDemo', 'selectItemList', '✅服务端查询-查询列表', 'sql', '{}', '{\"table\": \"student\", \"operation\": \"select\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (342, NULL, NULL, 'backendSearchDemo', 'insertItem', '✅服务端查询-添加成员', 'sql', '{}', '{\"table\": \"student\", \"operation\": \"insert\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (343, NULL, NULL, 'backendSearchDemo', 'updateItem', '✅服务端查询-更新成员', 'sql', '{}', '{\"table\": \"student\", \"operation\": \"jhUpdate\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (350, NULL, NULL, 'backendSearchDemo', 'deleteItem', '✅服务端查询-删除信息', 'sql', '{}', '{\"table\": \"student\", \"operation\": \"jhDelete\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (352, NULL, NULL, 'dataAccessRight', 'insertItem', '✅数据权限-添加成员', 'sql', '{}', '{\"table\": \"student\", \"operation\": \"insert\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (353, NULL, NULL, 'dataAccessRight', 'updateItem', '✅数据权限-更新成员', 'sql', '{}', '{\"table\": \"student\", \"operation\": \"jhUpdate\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (354, NULL, NULL, 'dataAccessRight', 'deleteItem', '✅数据权限-删除信息', 'sql', '{}', '{\"table\": \"student\", \"operation\": \"jhDelete\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (355, NULL, NULL, 'dataAccessRight', 'selectItemListByService', '✅数据权限-查询列表', 'service', '{}', '{\"service\": \"student\", \"serviceFunction\": \"selectStudentList\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (356, NULL, '{\"after\": [], \"before\": [{\"service\": \"student\", \"serviceFunction\": \"appendStudentInfoToUserInfo\"}]}', 'dataAccessRight', 'selectItemListByDynamicData', '✅数据权限-查询列表', 'sql', '{}', '{\"table\": \"student\", \"where\": {\"classId\": \"ctx.userInfo.studentInfo.classId\"}, \"operation\": \"select\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (374, NULL, NULL, 'student3Management', 'selectItemList', '✅student3Management查询-查询列表', 'sql', '{}', '{ \"table\": \"student3\", \"operation\": \"select\" }', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (375, NULL, NULL, 'student3Management', 'insertItem', '✅student3Management查询-添加成员', 'sql', '{}', '{ \"table\": \"student3\", \"operation\": \"insert\" }', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (376, NULL, NULL, 'student3Management', 'updateItem', '✅student3Management查询-更新成员', 'sql', '{}', '{ \"table\": \"student3\", \"operation\": \"jhUpdate\" }', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (377, NULL, NULL, 'student3Management', 'deleteItem', '✅student3Management查询-删除信息', 'sql', '{}', '{ \"table\": \"student3\", \"operation\": \"jhDelete\" }', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (378, NULL, NULL, 'protocolDemoMenu', 'selectItemList', '✅菜谱-查询菜谱列表', 'sql', '{}', '{\"table\": \"menu\", \"operation\": \"select\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (379, NULL, NULL, 'protocolDemoMenu', 'insertItem', '✅菜谱-添加菜品', 'sql', '{}', '{\"table\": \"menu\", \"operation\": \"insert\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (380, NULL, NULL, 'protocolDemoMenu', 'updateItem', '✅菜谱-修改菜品信息', 'sql', '{}', '{\"table\": \"menu\", \"operation\": \"jhUpdate\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (381, NULL, NULL, 'protocolDemoMenu', 'deleteItem', '✅菜谱-删除菜品', 'sql', '{}', '{\"table\": \"menu\", \"operation\": \"jhDelete\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (382, NULL, NULL, 'protocolDemoOrder', 'selectItemList', '✅订单-查询订单列表', 'sql', '{}', '{\"table\": \"order\", \"operation\": \"select\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (383, NULL, NULL, 'protocolDemoOrder', 'insertItem', '✅订单-添加订单', 'sql', '{}', '{\"table\": \"order\", \"operation\": \"insert\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (384, NULL, NULL, 'protocolDemoOrder', 'updateItem', '✅订单-修改订单信息', 'sql', '{}', '{\"table\": \"order\", \"operation\": \"jhUpdate\"}', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_resource` VALUES (385, NULL, NULL, 'protocolDemoOrder', 'deleteItem', '✅订单-删除订单', 'sql', '{}', '{\"table\": \"order\", \"operation\": \"jhDelete\"}', NULL, NULL, 'insert', NULL, NULL, NULL);

-- ----------------------------
-- Table structure for _resource_request_log
-- ----------------------------
DROP TABLE IF EXISTS `_resource_request_log`;
CREATE TABLE `_resource_request_log`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resourceId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT 'resource id;',
  `packageId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT 'resource package id',
  `userIp` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '用户ip;',
  `userAgent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '设备信息',
  `userId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '用户ID',
  `deviceId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '设备id',
  `userIpRegion` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '用户Ip区域',
  `executeSql` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '执行的sql',
  `requestBody` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL COMMENT '请求body',
  `responseBody` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL COMMENT '响应body',
  `responseStatus` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '执行的结果;  success, fail',
  `operation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT 'insert' COMMENT '操作; insert, update, jhInsert, jhUpdate, jhDelete jhRestore',
  `operationByUserId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者userId',
  `operationByUser` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者用户名',
  `operationAt` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作时间; E.g: 2021-05-28T10:24:54+08:00 ',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `resourceId_index`(`resourceId`) USING BTREE,
  INDEX `packageId_index`(`packageId`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4808 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = '文件表; 软删除未启用;' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of _resource_request_log
-- ----------------------------

-- ----------------------------
-- Table structure for _role
-- ----------------------------
DROP TABLE IF EXISTS `_role`;
CREATE TABLE `_role`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `roleId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT 'roleId',
  `roleName` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT 'role name',
  `roleDesc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT 'role desc',
  `operation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT 'insert' COMMENT '操作; insert, update, jhInsert, jhUpdate, jhDelete jhRestore',
  `operationByUserId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者userId',
  `operationByUser` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者用户名',
  `operationAt` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作时间; E.g: 2021-05-28T10:24:54+08:00 ',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 8 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = '角色表; 软删除未启用;' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of _role
-- ----------------------------
INSERT INTO `_role` VALUES (3, 'administrator', '系统管理员', '', 'insert', NULL, NULL, NULL);
INSERT INTO `_role` VALUES (6, 'boss', '掌门', '', 'insert', NULL, NULL, NULL);
INSERT INTO `_role` VALUES (7, 'disciple', '门徒', '', 'insert', NULL, NULL, NULL);

-- ----------------------------
-- Table structure for _ui
-- ----------------------------
DROP TABLE IF EXISTS `_ui`;
CREATE TABLE `_ui`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pageId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT 'page id; E.g: index',
  `uiActionType` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT 'ui 动作类型，如：fetchData, postData, changeUi',
  `uiActionId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT 'action id; E.g: selectXXXByXXX',
  `desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '描述',
  `uiActionConfig` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL COMMENT 'ui 动作数据',
  `appDataSchema` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL COMMENT 'ui 校验数据',
  `operation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT 'insert' COMMENT '操作; insert, update, jhInsert, jhUpdate, jhDelete jhRestore',
  `operationByUserId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者userId',
  `operationByUser` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者用户名',
  `operationAt` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作时间; E.g: 2021-05-28T10:24:54+08:00 ',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 70 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = 'ui 施工方案' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of _ui
-- ----------------------------
INSERT INTO `_ui` VALUES (1, 'uiAction', 'ui', 'refreshTableData', '✅获取表格数据', '{ \"main\": [{\"function\": \"refreshTableData\"}] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (3, 'uiAction', 'ui', 'startInsertItem', '✅打开创建数据抽屉', '{ \"main\": [{\"function\": \"clearCreateForm\"}, {\"function\": \"openCreateDrawer\"}] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (4, 'uiAction', 'ui', 'createItem', '✅创建数据', '{ \"before\": [{\"function\": \"prepareValidate\"}, {\"function\": \"prepareCreateItem\"}, {\"function\": \"confirmCreateFormDialog\"}], \"main\": [ {\"function\": \"doCreateItem\"}], \"after\": [{\"function\": \"closeCreateDrawer\"}, {\"function\": \"refreshTableData\"}] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (5, 'uiAction', 'ui', 'startUpdateItem', '✅打开更新数据抽屉', '{ \"main\": [{\"function\": \"fillUpdateForm\"}, {\"function\": \"openUpdateDrawer\"}] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (6, 'uiAction', 'ui', 'updateItem', '✅更新数据', '{ \"before\": [{\"function\": \"prepareValidate\"}, {\"function\": \"confirmUpdateItemDialog\"}], \"main\": [{\"function\": \"doUpdateItem\"}, {\"function\": \"refreshTableData\"}], \"after\": [{\"function\": \"closeUpdateDrawer\"}] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (7, 'uiAction', 'ui', 'deleteItem', '✅删除数据', '{ \"before\": [{\"function\": \"confirmDeleteItemDialog\"}], \"main\": [ {\"function\": \"doDeleteItem\"}, {\"function\": \"refreshTableData\"}], \"after\": [] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (11, 'uiActionComponent', 'ui', 'refreshTableData', '✅获取表格数据', '{ \"before\": [{\"vueComponent\": \"classSelectDialog\", \"function\": \"selectItem\", \"functionParamObj\": { \"item\": { \"value\": \"2021-01级-01班\" } }}], \"main\": [{\"function\": \"refreshTableData\"}] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (13, 'uiActionComponent', 'ui', 'startCreateItem', '✅打开创建数据抽屉', '{ \"main\": [{\"function\": \"clearItemData\"}, {\"function\": \"openCreateDialog\"}] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (14, 'uiActionComponent', 'ui', 'insertItem', '✅创建数据', '{ \"before\": [{\"function\": \"prepareValidate\"}, {\"vueComponent\": \"jhConfirmDialog\", \"function\": \"confirmDialog\", \"functionParamObj\": { \"title\": \"新增\", \"content\": \"确定新增吗？\" }}], \"main\": [{\"function\": \"prepareCreateItem\"}, {\"function\": \"doCreateItem\"}, {\"function\": \"refreshTableData\"}], \"after\": [{\"function\": \"closeDrawerShow\"}] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (15, 'uiActionComponent', 'ui', 'startUpdateItem', '✅打开更新数据抽屉', '{ \"main\": [{\"function\": \"prepareItemData\"}, {\"function\": \"openUpdateDialog\"}] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (16, 'uiActionComponent', 'ui', 'updateItem', '✅更新数据', '{ \"before\": [{\"function\": \"prepareValidate\"}, {\"vueComponent\": \"jhConfirmDialog\", \"function\": \"confirmDialog\", \"functionParamObj\": { \"title\": \"修改\", \"content\": \"确定修改吗？\" }}], \"main\": [{\"function\": \"doUpdateItem\"}, {\"function\": \"refreshTableData\"}], \"after\": [{\"function\": \"closeDrawerShow\"}] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (17, 'uiActionComponent', 'ui', 'deleteItem', '✅删除数据', '{ \"before\": [{\"vueComponent\": \"jhConfirmDialog\", \"function\": \"confirmDialog\", \"functionParamObj\": { \"title\": \"删除\", \"content\": \"确定删除吗？\" }}], \"main\": [{\"function\": \"prepareItemData\"}, {\"function\": \"doDeleteItem\"}, {\"function\": \"refreshTableData\"}], \"after\": [] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (30, 'resourceHook', 'ui', 'refreshTableData', '✅获取表格数据', '{ \"main\": [{\"function\": \"refreshTableData\"}] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (31, 'resourceHook', 'ui', 'startCreateItem', '✅打开创建数据抽屉', '{ \"main\": [{\"function\": \"clearItemData\"}, {\"function\": \"openCreateDialog\"}] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (32, 'resourceHook', 'ui', 'createItem', '✅创建数据', '{ \"before\": [{\"function\": \"prepareValidate\"}, {\"function\": \"confirmCreateItemDialog\"}], \"main\": [{\"function\": \"doCreateItem\"}, {\"function\": \"refreshTableData\"}], \"after\": [{\"function\": \"closeDrawerShow\"}] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (33, 'resourceHook', 'ui', 'startUpdateItem', '✅打开更新数据抽屉', '{ \"main\": [{\"function\": \"prepareItemData\"}, {\"function\": \"openUpdateDialog\"}] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (34, 'resourceHook', 'ui', 'updateItem', '✅更新数据', '{ \"before\": [{\"function\": \"prepareValidate\"}, {\"function\": \"confirmUpdateItemDialog\"}], \"main\": [{\"function\": \"doUpdateItem\"}, {\"function\": \"refreshTableData\"}], \"after\": [{\"function\": \"closeDrawerShow\"}] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (35, 'resourceHook', 'ui', 'deleteItem', '✅删除数据', '{ \"before\": [{\"function\": \"confirmDeleteItemDialog\"}], \"main\": [{\"function\": \"prepareItemData\"}, {\"function\": \"doDeleteItem\"}, {\"function\": \"refreshTableData\"}] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (40, 'backendSearchDemo', 'ui', 'refreshTableData', '✅获取表格数据', '{ \"main\": [{\"function\": \"refreshTableData\"}]}', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (41, 'backendSearchDemo', 'ui', 'startCreateItem', '✅打开创建数据抽屉', '{ \"main\": [{\"function\": \"clearItemData\"}, {\"function\": \"openCreateDialog\"}] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (42, 'backendSearchDemo', 'ui', 'createItem', '✅创建数据', '{ \"before\": [{\"function\": \"prepareValidate\"}, {\"function\": \"confirmCreateItemDialog\"}], \"main\": [{\"function\": \"doCreateItem\"}, {\"function\": \"refreshTableData\"}], \"after\": [{\"function\": \"closeDrawerShow\"}] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (43, 'backendSearchDemo', 'ui', 'startUpdateItem', '✅打开更新数据抽屉', '{ \"main\": [{\"function\": \"prepareItemData\"}, {\"function\": \"openUpdateDialog\"}] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (44, 'backendSearchDemo', 'ui', 'updateItem', '✅更新数据', '{ \"before\": [{\"function\": \"prepareValidate\"}, {\"function\": \"confirmUpdateItemDialog\"}], \"main\": [{\"function\": \"doUpdateItem\"}, {\"function\": \"refreshTableData\"}], \"after\": [{\"function\": \"closeDrawerShow\"}] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (45, 'backendSearchDemo', 'ui', 'deleteItem', '✅删除数据', '{ \"before\": [{\"function\": \"confirmDeleteItemDialog\"}], \"main\": [{\"function\": \"prepareItemData\"}, {\"function\": \"doDeleteItem\"}, {\"function\": \"refreshTableData\"}] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (50, 'dataAccessRight', 'ui', 'refreshTableData', '✅获取表格数据', '{ \"main\": [{\"function\": \"refreshTableData\"}] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (51, 'dataAccessRight', 'ui', 'startCreateItem', '✅打开创建数据抽屉', '{ \"main\": [{\"function\": \"clearItemData\"}, {\"function\": \"openCreateDialog\"}]}', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (52, 'dataAccessRight', 'ui', 'createItem', '✅创建数据', '{ \"before\": [{\"function\": \"prepareValidate\"}, {\"function\": \"confirmCreateItemDialog\"}], \"main\": [{\"function\": \"doCreateItem\"}, {\"function\": \"refreshTableData\"}], \"after\": [{\"function\": \"closeDrawerShow\"}] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (53, 'dataAccessRight', 'ui', 'startUpdateItem', '✅打开更新数据抽屉', '{ \"main\": [{\"function\": \"prepareItemData\"}, {\"function\": \"openUpdateDialog\"}] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (54, 'dataAccessRight', 'ui', 'updateItem', '✅更新数据', '{ \"before\": [{\"function\": \"prepareValidate\"}, {\"function\": \"confirmUpdateItemDialog\"}], \"main\": [{\"function\": \"doUpdateItem\"}, {\"function\": \"refreshTableData\"}], \"after\": [{\"function\": \"closeDrawerShow\"}] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (55, 'dataAccessRight', 'ui', 'deleteItem', '✅删除数据', '{ \"before\": [{\"function\": \"confirmDeleteItemDialog\"}], \"main\": [{\"function\": \"prepareItemData\"}, {\"function\": \"doDeleteItem\"}, {\"function\": \"refreshTableData\"}] }', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (64, 'student3Management', 'ui', 'refreshTableData', '✅获取表格数据', '{\"main\": [{\"function\": \"refreshTableData\"}]}', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (65, 'student3Management', 'ui', 'startCreateItem', '✅获取表格数据', '{\"main\": [{\"function\": \"clearItemData\"}, {\"function\": \"openCreateItemDialog\"}]}', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (66, 'student3Management', 'ui', 'createItem', '✅获取表格数据', '{\"before\": [{\"function\": \"confirmCreateItemDialog\"}], \"main\": [{\"function\": \"doCreateItem\"}, {\"function\": \"refreshTableData\"}], \"after\": [{\"function\": \"closeDrawerShow\"}]}', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (67, 'student3Management', 'ui', 'startUpdateItem', '✅获取表格数据', '{\"main\": [{\"function\": \"prepareItemData\"}, {\"function\": \"openUpdateDialog\"}]}', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (68, 'student3Management', 'ui', 'updateItem', '✅获取表格数据', '{\"before\": [{\"function\": \"confirmUpdateItemDialog\"}], \"main\": [{\"function\": \"doUpdateItem\"}, {\"function\": \"refreshTableData\"}], \"after\": [{\"function\": \"closeDrawerShow\"}]}', NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_ui` VALUES (69, 'student3Management', 'ui', 'deleteItem', '✅获取表格数据', '{\"before\": [{\"function\": \"confirmDeleteItemDialog\"}], \"main\": [{\"function\": \"doDeleteItem\"}, {\"function\": \"refreshTableData\"}]}', NULL, 'insert', NULL, NULL, NULL);

-- ----------------------------
-- Table structure for _user
-- ----------------------------
DROP TABLE IF EXISTS `_user`;
CREATE TABLE `_user`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idSequence` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '自增id; 用于生成userId',
  `userId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '主键id',
  `username` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '用户名(登陆)',
  `clearTextPassword` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '明文密码',
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '密码',
  `md5Salt` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT 'md5Salt',
  `userStatus` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT 'active' COMMENT '用户账号状态：活跃或关闭',
  `userType` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '用户类型; staff, student.',
  `config` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL COMMENT '配置信息',
  `operation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT 'insert' COMMENT '操作; insert, update, jhInsert, jhUpdate, jhDelete jhRestore',
  `operationByUserId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者userId',
  `operationByUser` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者用户名',
  `operationAt` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作时间; E.g: 2021-05-28T10:24:54+08:00 ',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `username_index`(`username`) USING BTREE,
  UNIQUE INDEX `userId_index`(`userId`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 49 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = '用户表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of _user
-- ----------------------------
INSERT INTO `_user` VALUES (42, NULL, 'admin', '系统管理员', '123456', '38d61d315e62546fe7f1013e31d42f57', 'Xs4JSZnhiwsR', 'active', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_user` VALUES (43, NULL, 'W00001', '张三丰', '123456', '38d61d315e62546fe7f1013e31d42f57', 'Xs4JSZnhiwsR', 'active', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_user` VALUES (44, NULL, 'W00002', '张无忌', '123456', '38d61d315e62546fe7f1013e31d42f57', 'Xs4JSZnhiwsR', 'active', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_user` VALUES (45, NULL, 'G00001', '洪七公', '123456', '38d61d315e62546fe7f1013e31d42f57', 'Xs4JSZnhiwsR', 'active', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_user` VALUES (46, NULL, 'G00002', '郭靖', '123456', '38d61d315e62546fe7f1013e31d42f57', 'Xs4JSZnhiwsR', 'active', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_user` VALUES (47, NULL, 'H00001', '岳不群', '123456', '38d61d315e62546fe7f1013e31d42f57', 'Xs4JSZnhiwsR', 'active', NULL, NULL, 'insert', NULL, NULL, NULL);
INSERT INTO `_user` VALUES (48, NULL, 'H00002', '令狐冲', '123456', '38d61d315e62546fe7f1013e31d42f57', 'Xs4JSZnhiwsR', 'active', NULL, NULL, 'insert', NULL, NULL, NULL);

-- ----------------------------
-- Table structure for _user_group_role
-- ----------------------------
DROP TABLE IF EXISTS `_user_group_role`;
CREATE TABLE `_user_group_role`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT '用户id',
  `groupId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT '群组Id',
  `roleId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '角色Id',
  `operation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT 'insert' COMMENT '操作; insert, update, jhInsert, jhUpdate, jhDelete jhRestore',
  `operationByUserId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者userId',
  `operationByUser` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者用户名',
  `operationAt` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作时间; E.g: 2021-05-28T10:24:54+08:00 ',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `groupId_index`(`groupId`) USING BTREE,
  INDEX `userId_index`(`userId`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 579 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = '用户群组角色关联表; 软删除未启用;' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of _user_group_role
-- ----------------------------
INSERT INTO `_user_group_role` VALUES (568, 'admin', 'adminGroup', 'administrator', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role` VALUES (569, 'W00001', 'wudang', 'boss', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role` VALUES (570, 'W00002', 'wudang', 'disciple', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role` VALUES (573, 'G00001', 'gaibang', 'boss', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role` VALUES (574, 'G00002', 'gaibang', 'disciple', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role` VALUES (577, 'H00001', 'huashan', 'boss', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role` VALUES (578, 'H00002', 'huashan', 'disciple', 'insert', NULL, NULL, NULL);

-- ----------------------------
-- Table structure for _user_group_role_page
-- ----------------------------
DROP TABLE IF EXISTS `_user_group_role_page`;
CREATE TABLE `_user_group_role_page`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT 'userId 或者 通配符; 通配符: *',
  `group` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT 'groupId 或者 通配符; 通配符: *',
  `role` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT 'roleId 或者 通配符; 通配符: *',
  `page` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT 'pageId id',
  `allowOrDeny` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '用户群组角色 匹配后 执行动作; allow、deny',
  `desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '映射描述',
  `operation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT 'insert' COMMENT '操作; insert, update, jhInsert, jhUpdate, jhDelete jhRestore',
  `operationByUserId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者userId',
  `operationByUser` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者用户名',
  `operationAt` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作时间; E.g: 2021-05-28T10:24:54+08:00 ',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 34 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = '用户群组角色 - 页面 映射表; 软删除未启用;' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of _user_group_role_page
-- ----------------------------
INSERT INTO `_user_group_role_page` VALUES (17, '*', 'public', '*', 'login', 'allow', '登陆页; 开放给所有用户;', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role_page` VALUES (18, '*', 'login', '*', 'manual', 'allow', '操作手册页; 开放给登陆用户;', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role_page` VALUES (19, '*', 'login', '*', 'help', 'allow', '帮助页; 开放给登陆用户;', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role_page` VALUES (21, '*', 'adminGroup', 'administrator', '*', 'allow', '所有页面; 开放给应用管理者;', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role_page` VALUES (27, '*', 'wudang', 'boss,disciple', 'protocolDemo', 'allow', 'studentManagement01; 开放给武当派派掌门&门徒;', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role_page` VALUES (28, '*', 'gaibang', 'boss,disciple', 'frontendDemo01,frontendDemo02', 'allow', 'studentManagement02&studentManagement03; 开放给丐帮掌门&门徒;', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role_page` VALUES (29, '*', 'huashan', 'boss,disciple', 'backendSearchDemo', 'allow', 'studentManagement04; 开放给华山派掌门&门徒;', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role_page` VALUES (30, '*', '*', 'boss,disciple', 'dataAccessRight', 'allow', '数据权限demo', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role_page` VALUES (31, '*', 'login', '*', '*', 'allow', '示范', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role_page` VALUES (32, '*', 'login', '*', 'protocolDemoMenu', 'allow', '菜谱；开放给登陆用户', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role_page` VALUES (33, '*', 'login', '*', 'protocolDemoOrder', 'allow', '订单；开放给登陆用户', 'insert', NULL, NULL, NULL);

-- ----------------------------
-- Table structure for _user_group_role_resource
-- ----------------------------
DROP TABLE IF EXISTS `_user_group_role_resource`;
CREATE TABLE `_user_group_role_resource`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT 'userId 或者 通配符; 通配符: *',
  `group` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT 'groupId 或者 通配符; 通配符: *',
  `role` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT 'roleId 或者 通配符; 通配符: *',
  `resource` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT 'resourceId 或者 通配符; 通配符: *, !resourceId',
  `allowOrDeny` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '用户群组角色 匹配后 执行动作; allow、deny',
  `desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '映射描述',
  `operation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT 'insert' COMMENT '操作; insert, update, jhInsert, jhUpdate, jhDelete jhRestore',
  `operationByUserId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者userId',
  `operationByUser` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者用户名',
  `operationAt` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作时间; E.g: 2021-05-28T10:24:54+08:00 ',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 137 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = '用户群组角色 - 请求资源 映射表; 软删除未启用;' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of _user_group_role_resource
-- ----------------------------
INSERT INTO `_user_group_role_resource` VALUES (1, '*', 'public', '*', 'login.passwordLogin', 'allow', '登陆resource, 开放给所有用户', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role_resource` VALUES (11, '*', 'public', '*', 'allPage.getConstantList', 'allow', '查询常量resource, 开放给所有登陆成功的用户', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role_resource` VALUES (31, '*', 'login', '*', 'allPage.logout', 'allow', '登出resource, 开放给所有登陆成功的用户', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role_resource` VALUES (32, '*', 'login', '*', 'allPage.refreshToken', 'allow', '刷新authToken resource, 开放给所有登陆成功的用户', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role_resource` VALUES (33, '*', 'login', '*', 'allPage.userInfo', 'allow', '用户个人信息resource, 开放给所有登陆成功的用户', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role_resource` VALUES (34, '*', 'login', '*', 'allPage.uploadByBase64', 'allow', '上传文件resource, 开放给所有登陆成功的用户', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role_resource` VALUES (35, '*', 'login', '*', 'allPage.uploadByStream', 'allow', '上传文件resource, 开放给所有登陆成功的用户', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role_resource` VALUES (51, '*', 'adminGroup', 'administrator', '*', 'allow', '应用管理者, 赋予所有resource权限', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role_resource` VALUES (117, '*', 'wudang', 'boss', 'protocolDemo.*', 'allow', 'page01 内的所有操作; 开放给武当派掌门;', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role_resource` VALUES (118, '*', 'wudang', 'disciple', 'protocolDemo.selectItemList', 'allow', 'page01 内的查询列表操作; 开放给武当派门徒;', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role_resource` VALUES (125, '*', 'gaibang', 'boss', 'frontendDemo01.*,frontendDemo02.*', 'allow', 'page02&page03 内的所有操作; 开放给丐帮掌门&门徒;', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role_resource` VALUES (126, '*', 'gaibang', 'disciple', 'frontendDemo01.selectItemList,frontendDemo02.selectItemList', 'allow', 'page02&page03 内的查询列表操作; 开放给丐帮掌门&门徒;', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role_resource` VALUES (131, '*', 'huashan', 'boss', 'backendSearchDemo.*', 'allow', 'page04 内的所有操作; 开放给华山派掌门&门徒;', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role_resource` VALUES (132, '*', 'huashan', 'disciple', 'backendSearchDemo.selectItemList', 'allow', 'page04 内的查询列表操作; 开放给华山派掌门&门徒;', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role_resource` VALUES (133, '*', '*', 'boss', 'dataAccessRight.*', 'allow', 'page05 内的所有操作; 开放给所有掌门', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role_resource` VALUES (134, '*', '*', 'disciple', 'dataAccessRight.selectItemList', 'allow', 'page05 内的查询列表操作; 开放给所有门徒;', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role_resource` VALUES (135, '*', 'login', '*', 'protocolDemoMenu.*', 'allow', '菜谱 页面内的所有操作；开放给所有登录用户；', 'insert', NULL, NULL, NULL);
INSERT INTO `_user_group_role_resource` VALUES (136, '*', 'login', '*', 'protocolDemoOrder.*', 'allow', '订单 页面内的所有权限；开放给所有登录用户；', 'insert', NULL, NULL, NULL);

-- ----------------------------
-- Table structure for _user_session
-- ----------------------------
DROP TABLE IF EXISTS `_user_session`;
CREATE TABLE `_user_session`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '用户id',
  `userIp` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '用户ip',
  `userIpRegion` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '用户Ip区域',
  `userAgent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL COMMENT '请求的 agent',
  `deviceId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '设备id',
  `deviceType` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT 'web' COMMENT '设备类型; flutter, web, bot_databot, bot_chatbot, bot_xiaochengxu',
  `socketStatus` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT 'offline' COMMENT 'socket状态',
  `authToken` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT 'auth token',
  `operation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT 'insert' COMMENT '操作; insert, update, jhInsert, jhUpdate, jhDelete jhRestore',
  `operationByUserId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者userId',
  `operationByUser` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者用户名',
  `operationAt` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作时间; E.g: 2021-05-28T10:24:54+08:00 ',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `userId_index`(`userId`) USING BTREE,
  INDEX `userId_deviceId_index`(`userId`, `deviceId`) USING BTREE,
  INDEX `authToken_index`(`authToken`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 26 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = '用户session表; deviceId 维度;软删除未启用;' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of _user_session
-- ----------------------------
INSERT INTO `_user_session` VALUES (25, 'G00001', '127.0.0.1', '', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.0.0 Safari/537.36', '127.0.0.1:7001_Windows.10.0_8246698a_chrome', 'web', 'offline', 'FCtJfZ35TABOne_DnD6Cfjcvj602gBR8Nj0C', 'jhInsert', NULL, NULL, '2022-08-25T23:31:54+08:00');

-- ----------------------------
-- Table structure for access_control_student
-- ----------------------------
DROP TABLE IF EXISTS `access_control_student`;
CREATE TABLE `access_control_student`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '主键id',
  `username` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '用户名(登陆)',
  `resourceData` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '明文密码',
  `operation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT 'insert' COMMENT '操作; insert, update, jhInsert, jhUpdate, jhDelete jhRestore',
  `operationByUserId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者userId',
  `operationByUser` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者用户名',
  `operationAt` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作时间; E.g: 2021-05-28T10:24:54+08:00 ',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `username_index`(`username`) USING BTREE,
  UNIQUE INDEX `userId_index`(`userId`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 52 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = '学生表的 accessControl 表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of access_control_student
-- ----------------------------
INSERT INTO `access_control_student` VALUES (50, 'G00001', '洪七公', '{ \"where\":{\"level\": \"02\"} }', 'insert', NULL, NULL, NULL);
INSERT INTO `access_control_student` VALUES (51, 'H00001', '岳不群', '{ \"where\":{\"level\": \"02\"} }', 'insert', NULL, NULL, NULL);

-- ----------------------------
-- Table structure for customer
-- ----------------------------
DROP TABLE IF EXISTS `customer`;
CREATE TABLE `customer`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customerId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `customerName` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `customerPhone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `operation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `operationByUserId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `operationByUser` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `operationAt` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of customer
-- ----------------------------

-- ----------------------------
-- Table structure for menu
-- ----------------------------
DROP TABLE IF EXISTS `menu`;
CREATE TABLE `menu`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menuId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '菜品ID',
  `dishName` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '菜品名称',
  `dishPicture` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '菜品图片',
  `price` int(10) NULL DEFAULT NULL COMMENT '价格',
  `likes` int(20) NULL DEFAULT NULL COMMENT '点赞',
  `operation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT 'insert' COMMENT '操作; insert, update, jhInsert, jhUpdate, jhDelete jhRestore',
  `operationByUserId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者userId',
  `operationByUser` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者用户名',
  `operationAt` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作时间; E.g: 2021-05-28T10:24:54+08:00 ',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 190 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of menu
-- ----------------------------
INSERT INTO `menu` VALUES (181, 'G00001', '锅包肉', './image/guobaorou.jpg', 15, 529, 'insert', NULL, NULL, NULL);
INSERT INTO `menu` VALUES (182, 'G00002', '马来风光', './image/malaifengguang.jpg', 6, 159, 'insert', NULL, NULL, NULL);
INSERT INTO `menu` VALUES (183, 'G00003', '佛跳墙', './image/fotiaoqiang.jpg', 30, 530, 'jhUpdate', 'G00001', '洪七公', '2022-09-08T23:18:09+08:00');
INSERT INTO `menu` VALUES (184, 'G00004', '麦片虾', './image/maipianxia.jpg', 22, 132, 'insert', NULL, NULL, NULL);

-- ----------------------------
-- Table structure for order
-- ----------------------------
DROP TABLE IF EXISTS `order`;
CREATE TABLE `order`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '订单编号',
  `customerId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '顾客编号',
  `menuId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '菜品编号',
  `orderDate` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '订单日期',
  `unitPrice` int(11) NULL DEFAULT NULL COMMENT '单价',
  `quantity` int(11) NULL DEFAULT NULL COMMENT '数量',
  `total` int(11) NULL DEFAULT NULL COMMENT '总价',
  `operation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `operationByUserId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `operationByUser` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `operationAt` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of order
-- ----------------------------

-- ----------------------------
-- Table structure for student
-- ----------------------------
DROP TABLE IF EXISTS `student`;
CREATE TABLE `student`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `studentId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '学生ID',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '学生名字',
  `gender` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '性别',
  `dateOfBirth` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '出生日期',
  `classId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '班级ID',
  `level` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '年级',
  `bodyHeight` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '身高',
  `studentStatus` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '学生状态',
  `remarks` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL COMMENT '备注',
  `operation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT 'insert' COMMENT '操作; insert, update, jhInsert, jhUpdate, jhDelete jhRestore',
  `operationByUserId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者userId',
  `operationByUser` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者用户名',
  `operationAt` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作时间; E.g: 2021-05-28T10:24:54+08:00 ',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `studentId`(`studentId`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 179 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of student
-- ----------------------------
INSERT INTO `student` VALUES (168, '100067', '1111', 'male', '2022-05-02', '2021-01级-01班', '01', NULL, NULL, NULL, 'jhUpdate', 'admin', '系统管理员', '2022-05-01T23:38:23+08:00');
INSERT INTO `student` VALUES (173, '121432', '21434', NULL, NULL, '2021-01级-01班', NULL, NULL, NULL, NULL, 'jhInsert', 'admin', '系统管理员', '2022-05-01T23:37:58+08:00');
INSERT INTO `student` VALUES (174, 'admin', '系统管理员', 'male', '2022-05-02', '2021-01级-01班', '01', NULL, NULL, NULL, 'jhUpdate', 'admin', '系统管理员', '2022-05-03T21:17:52+08:00');
INSERT INTO `student` VALUES (175, '1000221', '221', 'male', '2022-05-08', '2021-01级-02班', '01', NULL, NULL, NULL, 'jhUpdate', 'admin', '系统管理员', '2022-05-03T20:50:51+08:00');
INSERT INTO `student` VALUES (178, 'G00003', '小虾米', 'male', '2022-01-25', '2021-01级-02班', '03', '180', '正常', '小虾米', 'jhUpdate', 'G00001', '洪七公', '2022-09-01T23:01:11+08:00');

-- ----------------------------
-- Table structure for student2
-- ----------------------------
DROP TABLE IF EXISTS `student2`;
CREATE TABLE `student2`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `gender` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `operation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `operationByUserId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `operationByUser` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  `operationAt` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of student2
-- ----------------------------

-- ----------------------------
-- Table structure for student3
-- ----------------------------
DROP TABLE IF EXISTS `student3`;
CREATE TABLE `student3`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '学生名字',
  `gender` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '性别',
  `operation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT 'insert' COMMENT '操作; insert, update, jhInsert, jhUpdate, jhDelete jhRestore',
  `operationByUserId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者userId',
  `operationByUser` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者用户名',
  `operationAt` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作时间; E.g: 2021-05-28T10:24:54+08:00 ',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 188 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of student3
-- ----------------------------
INSERT INTO `student3` VALUES (181, '小花', '女', 'insert', NULL, NULL, NULL);
INSERT INTO `student3` VALUES (182, '小草', '男', 'insert', NULL, NULL, NULL);
INSERT INTO `student3` VALUES (183, '兰花', '女', 'insert', NULL, NULL, NULL);
INSERT INTO `student3` VALUES (184, '兰草', '男', 'insert', NULL, NULL, NULL);
INSERT INTO `student3` VALUES (185, '大花', '女', 'insert', NULL, NULL, NULL);
INSERT INTO `student3` VALUES (186, '大草', '男', 'insert', NULL, NULL, NULL);
INSERT INTO `student3` VALUES (187, '小龙虾', 'male', 'insert', 'G00001', '洪七公', '2022-09-01T23:16:12+08:00');

-- ----------------------------
-- Table structure for teacher
-- ----------------------------
DROP TABLE IF EXISTS `teacher`;
CREATE TABLE `teacher`  (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '序号',
  `teacherId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '老师编号',
  `teacherName` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '老师姓名',
  `gender` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '性别',
  `subject` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '教学科目，如：语文、数学',
  `operation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作',
  `operationByUserId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者用户ID',
  `operationByUser` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作者',
  `operationAt` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of teacher
-- ----------------------------

-- ----------------------------
-- View structure for _view01_user
-- ----------------------------
DROP VIEW IF EXISTS `_view01_user`;
CREATE ALGORITHM = UNDEFINED SQL SECURITY DEFINER VIEW `_view01_user` AS select `_user`.`id` AS `id`,`_user`.`idSequence` AS `idSequence`,`_user`.`userId` AS `userId`,`_user`.`username` AS `username`,`_user`.`clearTextPassword` AS `clearTextPassword`,`_user`.`password` AS `password`,`_user`.`md5Salt` AS `md5Salt`,`_user`.`userStatus` AS `userStatus`,`_user`.`userType` AS `userType`,`_user`.`config` AS `config`,`_user`.`operation` AS `operation`,`_user`.`operationByUserId` AS `operationByUserId`,`_user`.`operationByUser` AS `operationByUser`,`_user`.`operationAt` AS `operationAt` from `_user`;

SET FOREIGN_KEY_CHECKS = 1;
